/// Base exception class for the application
abstract class AppException implements Exception {
  final String message;
  final String? code;

  const AppException(this.message, [this.code]);

  @override
  String toString() => message;
}

/// Network related exceptions
class NetworkException extends AppException {
  const NetworkException(String message, [String? code]) : super(message, code);
}

/// Server related exceptions
class ServerException extends AppException {
  const ServerException(String message, [String? code]) : super(message, code);
}

/// Authentication related exceptions
class AuthException extends AppException {
  const AuthException(String message, [String? code]) : super(message, code);
}

/// Unauthorized access exception
class UnauthorizedException extends AuthException {
  const UnauthorizedException(String message, [String? code]) : super(message, code);
}

/// Forbidden access exception
class ForbiddenException extends AppException {
  const ForbiddenException(String message, [String? code]) : super(message, code);
}

/// Bad request exception
class BadRequestException extends AppException {
  const BadRequestException(String message, [String? code]) : super(message, code);
}

/// Not found exception
class NotFoundException extends AppException {
  const NotFoundException(String message, [String? code]) : super(message, code);
}

/// Validation exception with field errors
class ValidationException extends AppException {
  final Map<String, dynamic>? fieldErrors;

  const ValidationException(
    String message, [
    this.fieldErrors,
    String? code,
  ]) : super(message, code);
}

/// Cache related exceptions
class CacheException extends AppException {
  const CacheException(String message, [String? code]) : super(message, code);
}

/// Format related exceptions
class FormatException extends AppException {
  const FormatException(String message, [String? code]) : super(message, code);
}

/// Timeout exception
class TimeoutException extends NetworkException {
  const TimeoutException(String message, [String? code]) : super(message, code);
}

/// Connection exception
class ConnectionException extends NetworkException {
  const ConnectionException(String message, [String? code]) : super(message, code);
} 