import '../../domain/entities/ico_portfolio_entity.dart';

class IcoPortfolioModel {
  const IcoPortfolioModel({
    required this.totalInvested,
    required this.pendingInvested,
    required this.pendingVerificationInvested,
    required this.receivedInvested,
    required this.rejectedInvested,
    required this.currentValue,
    required this.totalProfitLoss,
    required this.roi,
  });

  final double totalInvested;
  final double pendingInvested;
  final double pendingVerificationInvested;
  final double receivedInvested;
  final double rejectedInvested;
  final double currentValue;
  final double totalProfitLoss;
  final double roi;

  factory IcoPortfolioModel.fromJson(Map<String, dynamic> json) {
    return IcoPortfolioModel(
      totalInvested: (json['totalInvested'] as num).toDouble(),
      pendingInvested: (json['pendingInvested'] as num).toDouble(),
      pendingVerificationInvested:
          (json['pendingVerificationInvested'] as num).toDouble(),
      receivedInvested: (json['receivedInvested'] as num).toDouble(),
      rejectedInvested: (json['rejectedInvested'] as num).toDouble(),
      currentValue: (json['currentValue'] as num).toDouble(),
      totalProfitLoss: (json['totalProfitLoss'] as num).toDouble(),
      roi: (json['roi'] as num).toDouble(),
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'totalInvested': totalInvested,
      'pendingInvested': pendingInvested,
      'pendingVerificationInvested': pendingVerificationInvested,
      'receivedInvested': receivedInvested,
      'rejectedInvested': rejectedInvested,
      'currentValue': currentValue,
      'totalProfitLoss': totalProfitLoss,
      'roi': roi,
    };
  }

  IcoPortfolioEntity toEntity() {
    return IcoPortfolioEntity(
      totalInvested: totalInvested,
      pendingInvested: pendingInvested,
      verificationInvested: pendingVerificationInvested,
      releasedValue: receivedInvested,
      totalProfitLoss: totalProfitLoss,
      profitLossPercentage: roi,
      totalTransactions: 0, // This would need to be calculated separately
      activeInvestments: 0, // This would need to be calculated separately
      completedInvestments: 0, // This would need to be calculated separately
      investments: const [], // This would need to be loaded separately
    );
  }
}
