import 'package:freezed_annotation/freezed_annotation.dart';
import '../../domain/entities/staking_pool_entity.dart';

part 'staking_pool_model.freezed.dart';
part 'staking_pool_model.g.dart';

@freezed
class StakingPoolModel with _$StakingPoolModel {
  const factory StakingPoolModel({
    required String id,
    required String name,
    required String? description,
    required String? icon,
    required String symbol,
    required double apr,
    required double minStake,
    required double? maxStake,
    required int lockPeriod, // in days
    required double availableToStake,
    required double totalStaked,
    required String status,
    required String poolType,
    @Default(false) bool isPromoted,
    @Default(false) bool autoCompound,
    int? maxPositionsPerUser,
    double? earlyWithdrawalPenalty,
    @Default(0) int order,
    DateTime? createdAt,
    DateTime? updatedAt,
    // Analytics data (optional, populated in some endpoints)
    @JsonKey(name: 'tvl') double? totalValueLocked,
    int? totalUsers,
    double? totalRewardsDistributed,
    // User specific data (optional)
    double? userStaked,
    int? userPositionCount,
  }) = _StakingPoolModel;

  factory StakingPoolModel.fromJson(Map<String, dynamic> json) =>
      _$StakingPoolModelFromJson(json);
}

extension StakingPoolModelX on StakingPoolModel {
  StakingPoolEntity toEntity() {
    return StakingPoolEntity(
      id: id,
      name: name,
      description: description,
      icon: icon,
      symbol: symbol,
      apr: apr,
      minStake: minStake,
      maxStake: maxStake,
      lockPeriod: lockPeriod,
      availableToStake: availableToStake,
      totalStaked: totalStaked,
      status: status,
      poolType: poolType,
      isPromoted: isPromoted,
      autoCompound: autoCompound,
      maxPositionsPerUser: maxPositionsPerUser,
      earlyWithdrawalPenalty: earlyWithdrawalPenalty,
      order: order,
      tvl: totalValueLocked ?? totalStaked,
      totalUsers: totalUsers,
      totalRewardsDistributed: totalRewardsDistributed,
      userStaked: userStaked,
      userPositionCount: userPositionCount,
    );
  }
}
